// hiscore.c

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "gworld.h"
#include "register.h"
#include "graphics.h"
#include "wdef.h"
#include "score.h"
#include "hiscore.h"
#include "keyselect.h"
#include "font.h"
#include "blitter.h"
#include "random.h"
#include "pause.h"
#include "level.h"
#include "stringtools.h"
#include "tutorial.h"
#include "graymonitor.h"
#include "players.h"
#include "gameticks.h"
#include "midi.h"
#include "soundfx.h"

Combo defaultBest = 
{
	/*bestGrid[kGridAcross][kGridDown] = */ 
	{ { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty,                          1, 1, 1, 2, 2 },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty,           1, 1 },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty } },

	/*bestA      = */ 2,
	/*bestB      = */ 2,
	/*bestM      = */ false, 
	/*bestG      = */ false, 
	/*bestLv     = */ kTutorialLevel,
	/*bestX      = */ 1,
	/*bestR      = */ upRotate,
	/*bestPlayer = */ 0,
	/*bestValue  = */ (40*1) + (50*9),
	/*bestName   = */ "Tutorial"
};

Combo best = 
{
	/*bestGrid[kGridAcross][kGridDown] = */ 
	{ { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty,                          1, 1, 1, 2, 2 },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty,           1, 1 },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty },
	  { kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty, kEmpty } },

	/*bestA      = */ 2,
	/*bestB      = */ 2,
	/*bestM      = */ false, 
	/*bestG      = */ false, 
	/*bestLv     = */ kTutorialLevel,
	/*bestX      = */ 1,
	/*bestR      = */ upRotate,
	/*bestPlayer = */ 0,
	/*bestValue  = */ (40*1) + (50*9),
	/*bestName   = */ "Tutorial"
};

Combo evenBetter = {0};
Combo potentialCombo[2];

AutoPattern hiScorePattern[] =
{
	{ kIdleTicks,          60, 0,   nil },	
	{ kBlockUntilDrop,     0,  0,   nil },	
	{ kBlockUntilComplete, 0,  0,   nil },	
	{ kIdleTicks,          60, 0,   nil },	
	{ kComplete,           0,  0,   nil }
};

HighScore scores[10] = 
{	
	{"Leviathan", 40000},
	{"Dr. Crisis", 36000},
	{"Angel", 32000},
	{"Spike", 28000},
	{"Fox", 24000},
	{"Raguel", 20000},
	{"Kumo", 16000},
	{"Patty", 12000},
	{"Yuurei", 8000},
	{"Glurp", 4000}  
};

HighScore defaultScores[10] = 
{	
	{"Leviathan", 40000},
	{"Dr. Crisis", 36000},
	{"Angel", 32000},
	{"Spike", 28000},
	{"Fox", 24000},
	{"Raguel", 20000},
	{"Kumo", 16000},
	{"Patty", 12000},
	{"Yuurei", 8000},
	{"Glurp", 4000}  
};

Str255 highScoreName = "\p";
char *highScoreText, *highScoreRank;

#define min(x,y) (((x)<(y))?(x):(y))

static void FadeScreen( GWorldPtr hiScoreWorld, GWorldPtr fadeWorld, int start, int end )
{
	int skip, timer, frame, fade, color, direction, fadeStart, fadeEnd;
	GrafPtr thePort;
	Rect fadeRect, portRect;
	
	if( start < end )
	{
		direction = 1;
		fadeStart = 0;
		fadeEnd = 32;
	}
	else
	{
		direction = -1;
		fadeStart = 32;
		fadeEnd = 0;
	}
	
	skip = 1;
	timer = TickCount( ) + 1;
	while( timer > TickCount() ) { }

	for( frame = start; (direction>0)? (frame <= end): (frame >= end); frame += direction )
	{
		Rect drawRect = {0, 0, 15, 640};
		timer+=skip;
		
		PrepareForGDrawing( fadeWorld );

		for( fade = fadeStart; fade != fadeEnd; fade += direction )
		{
			color = frame + fade;
			if( color <  0 ) color = 0;
			if( color > 31 ) color = 31;
			
			switch( color )
			{
				case 0:
					CopyBits( GetPortBitMapForCopyBits(hiScoreWorld), GetPortBitMapForCopyBits(fadeWorld), 
							   &drawRect,  &drawRect,  srcCopy,  nil );
					break;
			
				case 31:
					PaintRect( &drawRect );
					break;
				
				default:
					BlitColorOver( GetGWorldPixMap(hiScoreWorld), &drawRect, 0, 0, 0, color );
					break;
			}
			
			OffsetRect( &drawRect, 0, 15 );
		}

		FinishGDrawing( fadeWorld );		

		GetPort( &thePort );
		GetPortBounds( fadeWorld, &fadeRect );
		GetPortBounds( thePort,   &portRect );
		CopyBits( GetPortBitMapForCopyBits(fadeWorld), GetPortBitMapForCopyBits(thePort), 
				   &fadeRect, &portRect, srcCopy, nil );

		//QDFlushPortBuffer( thePort, nil );
		
		if( timer <= TickCount( ) )
		{
			skip = 2;
		}
		else
		{
			skip = 1;
			while( timer > TickCount( ) ) { MPYield(); }
		}
	}
}

void ShowHiscore( void )
{
	short count, length;
	Str255 myString;
	GWorldPtr hiScoreWorld, fadeWorld;
	SkittlesFontPtr font;
	RGBColor anyColor;
	Point dPoint;
	char *highScores = "HIGH SCORES";
	int r, g, b;
	KeyMap keys;
	const int deleteKey = 0x33;
	Rect titleRect;
	
	GetKeys( keys );
	if( KeyIsPressed( keys, deleteKey ) ) 
	{
		// If the user holds delete while opening the high scores,
		// clear the high score table.
		
		memcpy( &scores, &defaultScores, sizeof( scores ) );
		memcpy( &best,   &defaultBest,   sizeof( best   ) );
	}
	
	GetPortBounds( backdropPort, &titleRect );
	InitGWorld( &hiScoreWorld, &titleRect, 16 );
	InitGWorld( &fadeWorld,    &titleRect, 16 );

	font = GetFont( picHiScoreFont );
	PrepareForGDrawing( hiScoreWorld );

	DrawPictInGWorld( hiScoreWorld, picBackdrop + (100 * RandomBefore(IsRegistered()? kLevels: kSharewareLevels)) );
		
	GetCPixel( RandomBefore( titleRect.right ), RandomBefore( titleRect.bottom ), &anyColor );

	anyColor.red   = anyColor.red   * (32./65536.);
	anyColor.green = anyColor.green * (32./65536.);
	anyColor.blue  = anyColor.blue  * (32./65536.);
	anyColor.red   = min( 31, anyColor.red   + 14 );
	anyColor.green = min( 31, anyColor.green + 14 );
	anyColor.blue  = min( 31, anyColor.blue  + 14 );

	dPoint.v = 20;
	dPoint.h = 225;
	for( count=0; highScores[count]; count++ )
	{
		BlitCharacter( font, highScores[count], &dPoint, 31, 31, 31, 1 );			
	}
	
	for( count=0; count<=9; count++ )
	{
		r = ((31 * (10-count)) + (anyColor.red   * count)) / 10;
		g = ((31 * (10-count)) + (anyColor.green * count)) / 10;
		b = ((31 * (10-count)) + (anyColor.blue  * count)) / 10;
		
		dPoint.v = 75 + count * 38;
		dPoint.h = 85;
		
		if( count<9 )
		{
			BlitCharacter( font, count + '1', &dPoint, r, g, b, 1 );			
		}
		else
		{
			BlitCharacter( font, '1', &dPoint, r, g, b, 1 );			
			BlitCharacter( font, '0', &dPoint, r, g, b, 1 );			
		}
		
		BlitCharacter( font, '.', &dPoint, r, g, b, 1 );			
		BlitCharacter( font, ' ', &dPoint, r, g, b, 1 );			

		length = 0;
		while( scores[count].name[length] && dPoint.h < 430 )
		{
			BlitCharacter( font, scores[count].name[length++], &dPoint, r, g, b, 1 );			
		}
		
		
		while( dPoint.h < 450 )
		{
			BlitCharacter( font, '.', &dPoint, r, g, b, 1 );			
		}
		
		dPoint.h = 470;

		NumToString( scores[count].score, myString );
		for( length=1; length<=myString[0]; length++ )
		{
			BlitCharacter( font, myString[length], &dPoint, r, g, b, 1 );			
		}
	}
	
	FinishGDrawing( hiScoreWorld );
	
	SetPort( backdropPort );
	PaintRect( &titleRect );
	if( context && kGamma ) DSpContext_FadeGamma( context, 100, nil );

	FadeScreen( hiScoreWorld, fadeWorld, 31, -32 );
	do
	{
		MPYield();
		CheckKeys( false, nil, nil );
	}
	while( !AnyKeyIsPressed( ) && !Button() );
	FadeScreen( hiScoreWorld, fadeWorld, -31, 32 );
	
	if( context && kGamma ) DSpContext_FadeGamma( context, 0, nil );

	DisposeGWorld( hiScoreWorld );
	DisposeGWorld( fadeWorld );
	DisposeFont( font );
}

void InitPotentialCombos( void )
{
	memset( &potentialCombo[0], 0, sizeof(Combo) );
	memset( &potentialCombo[1], 0, sizeof(Combo) );
	potentialCombo[0].player = 0;
	potentialCombo[1].player = 1;
}

void SubmitCombo( Combo *in )
{
	if( in->value > best.value && in->value > evenBetter.value )
	{
		PlayMono( kContinueSnd );
		memcpy( &evenBetter, in, sizeof( Combo ) );
	}	
}

// Please note: This function may well be the biggest kludge in Candy Crisis.
// It relies on tons of insider knowledge. But it works.
void ShowBestCombo( void )
{
	SkittlesFontPtr font;
	char *bestCombo = "BEST COMBO", bestInfo[256], *scan;
	Point dPoint;
	int levelCap;
	
	font = GetFont( picHiScoreFont );
	
	StopBalloon( );
	InitGame( kAutoControl, kNobodyControl );
	scoreWindowVisible[0] = false;
	grayMonitorVisible[0] = false;

	level = best.lv;
	levelCap = IsRegistered()? kLevels: kSharewareSolitaireLevels;
	if( (level < 1 || level > levelCap) && level != kTutorialLevel ) 
	{
		memcpy( &best, &defaultBest, sizeof(best) );
		showStartMenu = true;
		return;
	}

	BeginRound( false );
	character[0].dropSpeed = 12;
	
	PrepareForGDrawing( backdropWorld );
	dPoint.v = 40;
	dPoint.h = 225;
	for( scan = bestCombo; *scan; scan++ )
	{
		BlitCharacter( font, *scan, &dPoint, 31, 31, 31, 1 );			
	}
		
	dPoint.v = 410;
	dPoint.h = 640;
	sprintf( bestInfo, "%s (%d points)", best.name, best.value );
	
	for( scan = bestInfo; *scan; scan++ )
	{
		dPoint.h -= font->width[*scan];
	}

	dPoint.h /= 2;
	for( scan = bestInfo; *scan; scan++ )
	{
		BlitCharacter( font, *scan, &dPoint, 31, 31, 31, 1 );			
	}
	FinishGDrawing( backdropWorld );
	DisposeFont( font );
	
	memcpy( grid[0], best.grid, kGridAcross * kGridDown );
	ResolveSuction( 0 );
	RedrawBoardContents( 0 );
	RefreshAll( );

	nextA[0] = best.a;
	nextB[0] = best.b;
	nextG[0] = best.g;
	nextM[0] = best.m;
	RetrieveBlobs( 0 );

	EraseSpriteBlobs( 0 );
	blobX[0] = best.x;
	blobR[0] = best.r;
	DrawSpriteBlobs( 0, kNoSuction );
	
	QuickFadeIn( nil );
	blobTime[0] = animTime[0] = GameTickCount( );

	autoPattern = hiScorePattern;	
	tutorialTime = 0;
}

void AddHiscore( long score )
{
	short count, item;
	char rank[50];
	char text[256], *playerName = "You", *twoPlayerNames[] = { "Player 1", "Player 2" };
	int highScoreLevel = -1;
	

	// Check for high score
	// (only do high scores if it's player vs CPU)
			
	if( players == 1 &&
	    control[0] == kPlayerControl &&
	    control[1] == kAIControl        )
	{		
		for( count=0; count<=9; count++ )
		{
			if( score >= scores[count].score )
			{				
				sprintf( rank, "%d points", score );
				highScoreLevel = count;
				break;
			}
		}
	}
	
	// Determine player's name for best combo

	if( players == 2 ) playerName = twoPlayerNames[evenBetter.player];


	// See if both best combo AND high score
		
	if( evenBetter.value > best.value && highScoreLevel != -1 )
	{
		
		sprintf( text, "You got a high score and the best combo!" );

		highScoreText = text;
		highScoreRank = rank;

		HandleDialog( kHiScoreDialog );

		if( !finished )
		{
			memcpy( &best, &evenBetter, sizeof(Combo) );
			if( highScoreName[0] > (kNameLength-1) ) highScoreName[0] = kNameLength-1;
			ConvertPString( highScoreName, best.name );

			for( item=8; item>=highScoreLevel; item-- )
			{
				BlockMoveData( &scores[item], &scores[item+1], sizeof( HighScore ) );
			}
			scores[highScoreLevel].score = score;
			ConvertPString( highScoreName, scores[highScoreLevel].name );				
		}
	}
	
	// See if best combo has been won
		
	else if( evenBetter.value > best.value )
	{

		sprintf( text, "Congratulations! %s got best combo!", playerName );
		
		highScoreText = text;
		highScoreRank = "";
				
		HandleDialog( kHiScoreDialog );
		
		if( !finished )
		{
			memcpy( &best, &evenBetter, sizeof(Combo) );
			if( highScoreName[0] > (kNameLength-1) ) highScoreName[0] = kNameLength-1;
			ConvertPString( highScoreName, best.name );
		}
	}

	// See if high score has been won
	
	else if( highScoreLevel != -1 )
	{
		highScoreText = "Congratulations! You got a high score!";
		highScoreRank = rank;

		HandleDialog( kHiScoreDialog );
		
		if( !finished )
		{
			for( item=8; item>=highScoreLevel; item-- )
			{
				BlockMoveData( &scores[item], &scores[item+1], sizeof( HighScore ) );
			}
			
			scores[highScoreLevel].score = score;
			
			if( highScoreName[0] > (kNameLength-1) ) highScoreName[0] = kNameLength-1;
			ConvertPString( highScoreName, scores[highScoreLevel].name );				
		}
	}
}
